/* ------------------------ DISPLAY GOOGLEMAP------------------------ */
function googleMap() {
	if (GBrowserIsCompatible()) {
		miniIcone = new google.maps.Icon();
		miniIcone.iconSize=new google.maps.Size(12,20);
		miniIcone.shadowSize=new google.maps.Size(20,22);
		miniIcone.iconAnchor=new google.maps.Point(6,20);
		miniIcone.infoWindowAnchor=new google.maps.Point(5,1);
		maCarte = new google.maps.Map2(document.getElementById("map_canvas"));
		maCarte.addControl(new google.maps.LargeMapControl3D());
		maCarte.addControl(new google.maps.MenuMapTypeControl());
		maCarte.enableScrollWheelZoom();
		maCarte.setCenter(new GLatLng(48.5, 0), 5);
		maCarte.addControl(new GMapTypeControl());
        maCarte.addMapType(G_PHYSICAL_MAP);
		maCarte.setMapType(G_HYBRID_MAP);
        maCarte.addControl(new GOverviewMapControl());
		maCarte.addControl(new GScaleControl());		
	}else{
		alert("Desole, l'API Google Maps n'est pas compatible avec votre navigateur.");
	}
}

/* ------------------------ASK BASE FOR COMBO BOX  ------------------------ */
function reqComboBox(choix){
	req = document.getElementById('req').value;
	xhr = createXhrObject();
	xhr.onreadystatechange = function() {genererHTMlCombo(xhr);};
	
	xhr.open("POST", "AskBase", false);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.send("req="+choix);
}

/* ------------------------FILL COMBO BOX ------------------------ */
function genererHTMlCombo(xhr){
	if(xhr.readyState == 4){
		if(xhr.status == 200){
			resp = xhr.responseText;			
			document.write(resp);
		}
	}
}

/* ------------------------MAKE REQUEST FOR DOMAIN LIST ------------------------ */
function majDomaine(){
	annee= document.getElementById('year1').value;
	theme = document.getElementById('combo1').value;
	req = document.getElementById('req1').value;
	xhr = createXhrObject();
	xhr.onreadystatechange = function() {genererHTMlList(xhr);};
	
	xhr.open("POST", "AskBase", false);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.send("annee="+annee+"&theme="+theme+"&req="+req);
}

/* ------------------------MAKE REQUEST FOR THEME LIST ------------------------ */
/**function majTheme(){
	annee= document.getElementById('year2').value;
	theme = document.getElementById('combo2').value;
	req = document.getElementById('reqD').value; 
	xhr = createXhrObject();
	xhr.onreadystatechange = function() {genererHTMlList(xhr);};
	
	xhr.open("POST", "AskBase", false);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.send("annee="+annee+"&theme="+theme+"&req="+req);
}
*/
/* ------------------------GENERATE THE LIST OF CONFERENCES ------------------------ */
function genererHTMlList(xhr){
	if(xhr.readyState == 4){
		if(xhr.status == 200){
			liste = xhr.responseText;	
			document.getElementById("list").innerHTML = liste;
		}
	}
}

/* ------------------------CLEAR MAP FUNCTION------------------------ */
function removeLocation(){
	maCarte.clearOverlays();
}

/* ------------------------SEND REQUEST TO SERVER for GoogleMap------------------------ */
function majGoogle(){
	annee= document.getElementById('annee').value;
	pays = document.getElementById('pays').value;
	req = document.getElementById('req').value;
	
	xhr = createXhrObject();
	xhr.onreadystatechange = function() {retour_res(xhr);};
	
	xhr.open("POST", "AskBase", false);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.send("annee="+annee+"&pays="+pays+"&req="+req);
	
	
}

/* ------------------------SEND REQUESTS TO SERVER for Graphics------------------------ */
function french_touch(){
	pays = document.getElementById('pays').value;
	req = document.getElementById('req2').value;
	
	xhr = createXhrObject();
	xhr.onreadystatechange = function() {retour_res_stats(xhr);};
	
	xhr.open("POST", "AskBase", false);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.send("pays="+pays+"&req="+req);
}

/* ------------------------CREATE XMLHTTPREQUEST------------------------ */
function createXhrObject(){
    if (window.XMLHttpRequest)
        return new XMLHttpRequest();
 
    if (window.ActiveXObject){
        var names = ["Msxml2.XMLHTTP.6.0","Msxml2.XMLHTTP.3.0","Msxml2.XMLHTTP","Microsoft.XMLHTTP"];
        for(var i in names){
            try{ 
				return new ActiveXObject(names[i]); 
			}catch(e){}
        }
    }
    window.alert("Votre navigateur ne prend pas en charge l'objet XMLHTTPRequest.");
    return null;
}

/* ------------------------SERVER RESPONSE: GoogleMap------------------------ */
var gmarkers=[];
var htmls=[];
function retour_res(xhr){
	if(xhr.readyState == 4){
		if(xhr.status == 200){
			var side_bar_html = "";
			while(gmarkers.pop());
			while(htmls.pop());
			var xmlDoc = xhr.responseXML;
			var markers = xmlDoc.documentElement.getElementsByTagName("marker");
			geocoder = new GClientGeocoder();
			geocoder.getLatLng(markers[0].getAttribute("Pays"), function(point) {
				maCarte.setCenter(new GLatLng(point.lat(), point.lng()), 4);
			});

			for (var i = 0; i < markers.length; i++){
				var ville = markers[i].getAttribute("Ville");
				var pays = markers[i].getAttribute("Pays");
				var loc = ville+","+pays;
				var titreConf = markers[i].getAttribute("TitreConference");
				var annee = markers[i].getAttribute("Annee");
				var infoHtml = "<b>"+titreConf+"</b><br/>"
								+"<b>Pays</b> : "+pays+"<br/>"
								+"<b>Ville</b> : "+ville+"<br/>"
								+"<b>Annee</b> : "+annee+"<br/>";

				geocode(loc, infoHtml,i);
				
				if(i<30){
					htmls[i] = infoHtml;
					if(titreConf.length>10){
						titreConf = titreConf.substring(0, 10);
						titreConf= titreConf+"...";
					}
					side_bar_html += '<a href="javascript:click_side(' + i + ')">' + titreConf + '<\/a><br>';
				}
			}
			document.getElementById("side_bar").innerHTML = side_bar_html;
		}
	}
}

/* ------------------------PICKS UP side_bar click and OPENS INFO WINDOW------------------------ */
function click_side(i) {
	gmarkers[i].openInfoWindowHtml(htmls[i]);
}


/* ------------------------SERVER RESPONSE: Graphics------------------------ */
function retour_res_stats(xhr){
	if(xhr.readyState == 4){
		if(xhr.status == 200){
			var xmlDoc = xhr.responseXML; 
			var tableAnnee = new Array("2006","2007", "2008","2009", "2010");
			var tablePourcent = new Array(0, 0, 0, 0, 0);
			var totalConf = xmlDoc.getElementsByTagName("ConferencePays")[0].getAttribute("total");
			
			annees = xmlDoc.getElementsByTagName("Annee");
			
			for(var i=0; i<annees.length; i++){
				
				if(annees[i].hasChildNodes()){
					var annee = annees[i].childNodes[0].nodeValue;
			
					for(var j = 0; j < tableAnnee.length; j++){
						if(annee == tableAnnee[j].toString()){
							tablePourcent[j]++;
						}
					}
				}
			}
			camember(tableAnnee, tablePourcent);
		}
	}
}

/* ------------------------MARKERS CREATION------------------------ */
function createMarker(point,infoHtml) {
    var marker = new GMarker(point);
    google.maps.Event.addListener(marker, "click", function(){
        marker.openInfoWindowHtml(infoHtml);
    });
    return marker;
}

/* ------------------------SEARCH COORDINATES WITH THE NAME OF TOWN------------------------ */
function geocode(address, infoHtml, i) {
	geocoder = new GClientGeocoder();
	
	geocoder.getLatLng(address, function(point) {
		var marker = createMarker(point, infoHtml);
		if(i<30) gmarkers[i]=marker;
		maCarte.addOverlay(marker);
    });
}

/* ------------------------CREATE GRAPHIC CAMEMBERT------------------------ */			
function camember(tableAnnee, tablePourcent) {
	if(tableAnnee!=null && tablePourcent!=null){
		var data = new google.visualization.DataTable();
		
		data.addColumn('string', 'Pays');
		data.addColumn('number', 'nbConferences'); 
		
		var taille = tableAnnee.length;
		data.addRows(taille);

		for(var i=0; i<taille; i++){
			data.setValue(i, 0, tableAnnee[i]);
			data.setValue(i, 1, tablePourcent[i]);
		}
		
		var chart = new google.visualization.PieChart(document.getElementById('chart_div'));
		chart.draw(data, {width: 460, height: 310, title: 'Conferences PAR Annee', is3D: true});
	}
}

