package fr.unice.gfarce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet implementation class AskBase
 */
public class AskBase extends HttpServlet {
	private static final long serialVersionUID = 1L;

	String host;
	int port;
	Socket socket;
	BufferedReader istream;
	PrintWriter ostream;
	String nomReqXquery;
	String pays;
	String annee;
	String name;
	String theme;
	PrintWriter out2;
	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public AskBase() {
		super();
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doPost(request,response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		connexion();
		out2 = response.getWriter();
		getParam(request);
		String req = createRequest();
		String resXml=getRes(req);
		String entete = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n";
	
		out2.println(entete+resXml);
	}
	
	/**
	 * return the type of request (google,...)
	 */
	private String getRequestName(){
		String[] nomReq = nomReqXquery.split("/");
        String[] nomFic = nomReq[nomReq.length - 1].split("\\.");
        return nomFic[0];
	}

	/**
	 * make a connection with database
	 */
	private void connexion(){
		host = "78.241.56.189";
		port = 4001;
		try {
			socket = new Socket(host,port);
			InputStream in = socket.getInputStream();
			InputStreamReader reader = new InputStreamReader(in);
			istream = new BufferedReader(reader);
			OutputStream out = socket.getOutputStream();
			ostream = new PrintWriter(out);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Set the parameters' request
	 * @param request
	 */
	private void getParam(HttpServletRequest request){
		nomReqXquery= request.getParameter("req");
		pays= request.getParameter("pays");
		annee = request.getParameter("annee");
		name = request.getParameter("name");
		theme= request.getParameter("theme");
	}
	
	/**
	 * Create the request for the database
	 * @return request null if don't know request
	 */
	private String createRequest(){
		if(getRequestName().equals("ProjectByNameThem")){ 
			
			return "GET "+nomReqXquery+"?name="+theme+"&year="+annee;
		}
		if(getRequestName().equals("google")){
			return "GET "+nomReqXquery+"?pays="+pays+"&year="+annee;
		}
		if(getRequestName().equals("AllTitleOfTheme")){
			return "GET "+nomReqXquery;
		}
		if(getRequestName().equals("conferenceByProject")){
			return "GET "+nomReqXquery+"?year="+annee+"&name="+name;
		}
		if(getRequestName().equals("conferenceByProject")){
			return "GET "+ nomReqXquery+"?year="+annee+"&name="+name;
		}
		if(getRequestName().equals("ProjectByTheme")){
			return "GET "+ nomReqXquery+"?year="+annee+"&name="+name;
		}
		if(getRequestName().equals("ThemeByProject")){
			return "GET "+ nomReqXquery+"?year="+annee+"&name="+name;
		}
		if(getRequestName().equals("AllTitleOfTheme2")){
			return "GET "+ nomReqXquery;
		}
		if(getRequestName().equals("AllTitleOfTheme2009")){
			return "GET "+ nomReqXquery;
		}
		if(getRequestName().equals("stat")){
			return "GET "+ nomReqXquery+"?pays="+pays;
		}
		else{
			return null;
		}
	}

	/**
	 * Make a request to the database and return the result
	 * @return result of the request
	 * @throws IOException
	 */
	private String getRes(String req) throws IOException{
		ostream.println(req);
		ostream.flush();
		String res="";
		String inter="";
		while(inter !=null){
			inter=istream.readLine();
			if(inter!=null){
				res +="\n"+ inter;	
			}
		}
		ostream.close();
		istream.close();	
		return res;
	}
}
