xquery version "1.0";
import module namespace web = "http://ns.inria.org/xquery/web" at "web.xqm";
declare default collation "?lang=en&amp;strength=primary&amp;decomposition=none";
let $year := xs:string(web:get-parameter("year", ""))
let $name := xs:string(web:get-parameter("name", ""))
let $tmp := for $project in collection(concat('/db/Raweb/RA',$year))/raweb/identification
			where $project/theme = $name
				return
					<project>
						<ProjectTitle>{$project/shortname/text()} </ProjectTitle>   
						<ProjectName> {$project/projectName/text()} </ProjectName> 
						<Year> {$year}</Year>
					</project>
return  <Projects TotalProject = "{count($tmp)}">  {$tmp}  </Projects>