xquery version "1.0";
import module namespace web = "http://ns.inria.org/xquery/web" at "web.xqm";
declare default collation "?lang=en&amp;strength=primary&amp;decomposition=none";
let $year := xs:string(web:get-parameter("year", ""))
let $name := xs:string(web:get-parameter("name", ""))
let $project := for $projectName in collection(concat('/db/Raweb/RA',$year))/raweb
			return if($projectName/identification/shortname = $name) then( 
				 	if($year != "2009" )
							then(						
								 <marker  Theme =  "{$projectName/identification/theme}"/>)
							else
								 <marker  Theme =  "{$projectName/identification/theme-de-recherche}"/>)
							 else()
							 
return  <markers TotalTheme = "{count($project)}">  {$project}  </markers>