xquery version "1.0";
import module namespace web = "http://ns.inria.org/xquery/web" at "web.xqm";
declare default collation "?lang=en&amp;strength=primary&amp;decomposition=none";
let $year := xs:string(web:get-parameter("year", ""))
let $pays := xs:string(web:get-parameter("pays", ""))

return if(not($pays) and not($year))
then(
let $tmp := for $conf in collection('/db/Raweb/Data')/conferences/conf
let $tokens := tokenize($conf[1]/Quantile/Lieu,',')
			return
					<marker TitreConference = "{$conf[1]/TitreConference}" Annee = "{$conf[1]/Quantile/Annee}" Pays = "{$tokens[2]}" Ville = "{$tokens[1]}"/>
return  <markers> {$tmp} </markers>
)
else
let $year := xs:string(web:get-parameter("year", ""))
let $pays := xs:string(web:get-parameter("pays", ""))

return if(not($pays) and $year)
then(
let $tmp := for $conf in collection('/db/Raweb/Data')/conferences/conf
let $tokens := tokenize($conf[1]/Quantile/Lieu,',')
			where $conf[Quantile/Annee = $year]
			return if(count($conf/Quantile/Lieu) = 1) then
					(<marker TitreConference = "{$conf[1]/TitreConference}" Annee = "{$conf[1]/Quantile/Annee}" Pays = "{$tokens[2]}" Ville = "{$tokens[1]}"/>)
				else()
return  <markers> {$tmp} </markers>
)
else
let $year := xs:string(web:get-parameter("year", ""))
let $pays := xs:string(web:get-parameter("pays", ""))

return if($year and $pays)
then(
let $tmp := for $conf in collection('/db/Raweb/Data')/conferences/conf
let $tokens := tokenize($conf[1]/Quantile/Lieu,',')
			where $conf[Quantile/Annee = $year]
			and $conf[Quantile/Lieu/@code =$pays ]
			return if(count($conf/Quantile/Lieu) = 1 and count($conf/Quantile/Annee) = 1) then
					(<marker TitreConference = "{$conf[1]/TitreConference}" Annee = "{$conf[1]/Quantile/Annee}" Pays = "{$tokens[2]}" Ville = "{$tokens[1]}"/>)
				else()

return  <markers> {$tmp} </markers>
)
else
let $year := xs:string(web:get-parameter("year", ""))
let $pays := xs:string(web:get-parameter("pays", ""))

return if($pays and not($year))
then(
let $tmp := for $conf in collection('/db/Raweb/Data')/conferences/conf
let $tokens := tokenize($conf[1]/Quantile/Lieu,',')
			where $conf[Quantile/Lieu/@code =$pays ]
			order by($conf/Quantile/Annee) descending
			return if(count($conf/Quantile/Lieu) = 1) then
				(<marker TitreConference = "{$conf[1]/TitreConference}" Annee = "{$conf[1]/Quantile/Annee}" Pays = "{$tokens[2]}" Ville = "{$tokens[1]}"/>)
				else()
return  <markers> {$tmp} </markers>
)
else()
