xquery version "1.0";
import module namespace web = "http://ns.inria.org/xquery/web" at "web.xqm";
declare default collation "?lang=en&amp;strength=primary&amp;decomposition=none";
let $pays := xs:string(web:get-parameter("pays", "")) 
let $tmp := for $conf in collection('/db/Raweb/Data')/conferences/conf
			where  $conf[Quantile/Lieu/@code = $pays ]
			return 
				<confYear>
					<TitreConference> {$conf/TitreConference/text()} </TitreConference>
					<year>
						{$conf/Quantile/Annee}
					</year>
				</confYear>
return <ConferencePays total = "{count($tmp)}"> {$tmp} </ConferencePays>